<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <link rel="shortcut icon" href="favicon.ico" type="image/x-icon">
    <title>Ressources</title>
</head>
<body class="bg-gray-50 text-gray-800">

    <!-- Sidebar -->
    <?php 
        session_start();
        include('sidebar.php');
    ?>

    <!-- Main Content -->
    <main class="ml-64 p-8 min-h-screen">
        <?php
        if (isset($_SESSION["login"])) {
            include 'conn.php';
            $requete = "SELECT * FROM matieres";
            $stmt = $db->query($requete);
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        ?>
        
        <!-- Retour et Titre -->
        <a href="accueil." class="flex items-center text-blue-600 hover:underline mb-6">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                <path stroke-linecap="round" stroke-linejoin="round" d="M15 19l-7-7 7-7" />
            </svg>
            Retour à l'accueil
        </a>
        <h1 class="text-4xl font-bold text-center text-gray-800 mb-8">Ressources</h1>

        <!-- Fil d'Ariane -->
        <div class="text-sm text-gray-600 mb-8">
            <a href="accueil.php" class="text-blue-600 hover:underline">Accueil</a>
            <span class="mx-2">></span>
            <span class="font-semibold text-gray-800">Ressources</span>
        </div>

        <!-- Section Matières -->
        <section class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-6">
            <?php 
            foreach($result as $matieres) {
                echo "
                <div class='bg-white shadow-lg rounded-lg overflow-hidden transform transition hover:scale-105 hover:shadow-2xl'>
                    <a href='ressources-cours.php?id={$matieres["id_matiere"]}' class='block'>
                        <img src='{$matieres["matiere_img"]}' alt='{$matieres["nom_matiere"]}' class='w-full h-40 object-cover'>
                        <div class='p-4'>
                            <p class='text-center text-lg font-medium text-gray-900'>{$matieres["nom_matiere"]}</p>
                        </div>
                    </a>
                </div>
                ";
            }
            ?>
        </section>
        <?php
        }
        ?>
    </main>

    <!-- Footer -->
    <footer class="bg-gray-900 text-white text-center py-4 mt-10">
        <p>&copy; 2025 Votre Site - Tous droits réservés.</p>
    </footer>

</body>
</html>
