<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="shortcut icon" href="favicon.ico" type="image/x-icon">
    <title>Ressources Cours</title>
</head>
<body class="bg-gray-50">

    <!-- Navbar -->
    <header class="bg-white shadow-md">
        <div class="container mx-auto px-4 py-4 flex items-center justify-between">
            <a href="accueil.php" class="text-2xl font-bold text-blue-600">ENT</a>
            <nav class="space-x-6">
                <a href="accueil.php" class="text-gray-700 hover:text-blue-600 transition">Accueil</a>
                <a href="ressources.php" class="text-gray-700 hover:text-blue-600 transition">Ressources</a>
                <a href="administration.php" class="text-gray-700 hover:text-blue-600 transition">Administration</a>
                <a href="messagerie.php" class="text-gray-700 hover:text-blue-600 transition">Messagerie</a>
            </nav>
            <a href="parametres.php" class="flex items-center space-x-2 text-gray-700 hover:text-blue-600 transition">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M12 8v4l3 3m1 8a9 9 0 11-6 0m1-3h4m2 0h4" />
                </svg>
                <span>Paramètres</span>
            </a>
        </div>
    </header>

    <!-- Main Content -->
    <main class="container mx-auto px-4 py-8">
        <div class="mb-6">
            <a href="ressources.php" class="inline-flex items-center text-blue-600 font-medium hover:underline">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M15 19l-7-7 7-7" />
                </svg>
                Retour à la liste des ressources
            </a>
        </div>

        <?php
        include 'conn.php';
        $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        if (isset($_GET['id'])) {
            $id = $_GET['id'];

            $requete = "SELECT * FROM matieres WHERE id_matiere = :id";
            $stmt = $db->prepare($requete);
            $stmt->bindParam(':id', $id, PDO::PARAM_INT);
            $stmt->execute();

            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
            foreach ($result as $matieres) {
        ?>
            <h1 class="text-4xl font-bold text-gray-800 mb-4"><?php echo $matieres['nom_matiere']; ?></h1>
            <div class="text-sm text-gray-600 mb-6">
                <a href="accueil.php" class="text-blue-600 hover:underline">Accueil</a>
                <span class="mx-2">></span>
                <a href="ressources.php" class="text-blue-600 hover:underline">Ressources</a>
                <span class="mx-2">></span>
                <span class="font-medium text-gray-800"><?php echo $matieres['nom_matiere']; ?></span>
            </div>
        <?php
            }
        }
        ?>

        <section class="space-y-6">
            <video controls src="" class="w-full h-64 object-cover rounded-lg shadow-md"></video>

            <?php
            $requete = "SELECT * FROM cours WHERE id_matiere = :id";
            $stmt = $db->prepare($requete);
            $stmt->bindParam(':id', $id, PDO::PARAM_INT);
            $stmt->execute();

            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
            foreach ($result as $cours) {
                echo "
                <div class='bg-white p-6 rounded-lg shadow-md'>
                    <h2 class='text-2xl font-semibold text-gray-800 mb-2'>{$cours['nom_cours']}</h2>
                    <p class='text-gray-700 mb-4'>{$cours['contenu']}</p>
                    <p class='text-sm text-gray-500'>{$cours['date']}</p>
                </div>
                ";
            }
            ?>
        </section>
    </main>

    <!-- Footer -->
    <footer class="bg-gray-800 text-white text-center py-4">
        <p>&copy; 2025 Votre Site - Tous droits réservés</p>
    </footer>

</body>
</html>
