<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Messagerie</title>
    <?php include('header.php'); ?>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        html, body {
            height: 100%;
            margin: 0;
        }
    </style>
</head>
<body class="bg-[#f2f6fa] font-sans text-h1 flex">

    <!-- Include Sidebar -->
    <?php
    session_start();
    include('sidebar.php'); 
    ?>

    <!-- Overlay (for mobile) -->
    <div id="overlay" class="fixed inset-0 bg-black bg-opacity-50 z-20 hidden"></div>

    <!-- Main Content -->
    <div class="flex-1 flex flex-col">
        <!-- Mobile Header -->
        <div class="p-4 lg:hidden fixed top-0 left-0 w-full bg-[#f2f6fa] z-40 shadow-md">
            <button id="menu-button" class="text-blue-500">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M4 6h16M4 12h16m-7 6h7" />
                </svg>
            </button>
        </div>

        <!-- Messagerie Content -->
        <div class="mt-16 p-4 flex flex-col justify-center items-center flex-grow">
            <div class="w-full max-w-6xl flex flex-col md:flex-row gap-6">
                <!-- Colonne messagerie -->
                <div class="flex-1 bg-[#f2f6fa] p-6 rounded-lg shadow-lg flex flex-col justify-between">
                    <h2 class="text-2xl font-bold mb-4 text-gray-700">Messagerie</h2>
                    <div id="messageContainer" 
                        class="flex-grow space-y-4 overflow-y-auto p-4 bg-purple-100 rounded-lg" 
                        style="max-height: 400px; min-height: 300px;">
                    </div>
                    <div class="flex items-center justify-center mt-4 bg-gray-100 rounded-lg">
                        <div class="chat-image avatar my-auto pr-2 hidden md:block">
                            <div class="w-10 rounded-full mr-4">
                                <img alt="Avatar" src="https://via.placeholder.com/40" />
                            </div>
                        </div>
                        <input 
                            id="messageInput"
                            type="text" 
                            placeholder="Écrit ton message..." 
                            class="flex-grow p-3 bg-[#f2f6fa] rounded-lg border border-gray-300 text-gray-700"
                        >
                        <button id="sendMessage" class="ml-3 bg-purple-500 text-white p-3 w-12 h-12 rounded-full shadow-md hover:bg-purple-600">
                            <i class="fas fa-paper-plane"></i>
                        </button>
                    </div>
                </div>

                <!-- Colonne contacts -->
                <div class="w-full md:w-1/3 bg-white p-6 rounded-lg shadow-lg flex flex-col">
                    <h2 class="text-2xl font-bold mb-4 text-gray-700">Contact</h2>
                    <div class="space-y-4">
                        <div class="flex items-center justify-between p-3 bg-purple-100 rounded-lg shadow cursor-pointer" onclick="loadChat('Marie')">
                            <span class="text-gray-700 font-medium">Nom : Marie</span>
                        </div>
                        <div class="flex items-center justify-between p-3 bg-purple-100 rounded-lg shadow cursor-pointer" onclick="loadChat('Paul')">
                            <span class="text-gray-700 font-medium">Nom : Paul</span>
                        </div>
                    </div>
                    <a href="#" class="mt-6 text-blue-500 hover:underline text-sm font-medium">Tous les contacts →</a>
                </div>
                
            </div>
            <!-- Section calendrier -->
        <div class="w-full max-w-6xl mt-6 p-6 rounded-lg shadow-lg">
            <h2 class="text-2xl font-bold mb-4 text-gray-700">Calendrier</h2>
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4">
                <div class="bg-calendrier-card-bg1 p-4 rounded-lg shadow hover:shadow-md">
                    <h3 class="font-bold text-gray-700">Partiel</h3>
                    <p class="text-sm text-gray-600">Date : 10/12</p>
                    <p class="text-sm text-gray-600">Amphi : Blaise Pascal</p>
                </div>
                <div class="bg-calendrier-card-bg2 p-4 rounded-lg shadow hover:shadow-md">
                    <h3 class="font-bold text-gray-700">Deadline - CV Vidéo</h3>
                    <p class="text-sm text-gray-600">Date : 26/12</p>
                    <p class="text-sm text-gray-600">Rendu : Impression</p>
                </div>
                <div class="bg-calendrier-card-bg1 p-4 rounded-lg shadow hover:shadow-md">
                    <h3 class="font-bold text-gray-700">Deadline - Portfolio</h3>
                    <p class="text-sm text-gray-600">Date : 31/12</p>
                    <p class="text-sm text-gray-600">Rendu : URL Site Web</p>
                </div>
            </div>
        </div>
    </div>
        </div>
    </div>

    <script>
        // Gestion de la sidebar
        const menuButton = document.getElementById('menu-button');
        const sidebar = document.getElementById('sidebar');
        const overlay = document.getElementById('overlay');

        menuButton.addEventListener('click', () => {
            sidebar.classList.remove('-translate-x-full');
            overlay.classList.remove('hidden');
        });

        overlay.addEventListener('click', () => {
            sidebar.classList.add('-translate-x-full');
            overlay.classList.add('hidden');
        });

        // Logique de la messagerie intacte
        const messageInput = document.getElementById("messageInput");
        const messageContainer = document.getElementById("messageContainer");
        const sendMessage = document.getElementById("sendMessage");

        const conversations = {
            Marie: [
                { sender: "Marie", text: "Bonjour madame, Suite à notre précédent échange...", time: "12:45", type: "chat-start", avatar: "https://via.placeholder.com/40" }
            ],
            Paul: []
        };

        let currentContact = "Marie";

        const renderChat = () => {
            const chatMessages = conversations[currentContact] || [];
            messageContainer.innerHTML = chatMessages.map(msg => `
                <div class="chat ${msg.type}">
                    <div class="chat-image avatar">
                        <div class="w-10 rounded-full">
                            <img alt="Avatar" src="${msg.avatar}" />
                        </div>
                    </div>
                    <div class="chat-header">
                        ${msg.sender}
                        <time class="text-xs opacity-50">${msg.time}</time>
                    </div>
                    <div class="chat-bubble chat-bubble-${msg.type === "chat-end" ? "info" : "primary"} text-white">
                        ${msg.text}
                    </div>
                </div>
            `).join('');
            messageContainer.scrollTop = messageContainer.scrollHeight;
        };

        const sendChatMessage = () => {
            const messageText = messageInput.value.trim();
            if (messageText) {
                const time = new Date().toLocaleTimeString([], { hour: '2-digit', minute: '2-digit' });
                const newMessage = {
                    sender: "Moi",
                    text: messageText,
                    time,
                    type: "chat-end",
                    avatar: "https://via.placeholder.com/40"
                };
                conversations[currentContact] = conversations[currentContact] || [];
                conversations[currentContact].push(newMessage);
                messageInput.value = '';
                renderChat();
            }
        };

        sendMessage.addEventListener("click", sendChatMessage);

        messageInput.addEventListener("keydown", (event) => {
            if (event.key === "Enter") {
                sendChatMessage();
                event.preventDefault();
            }
        });

        const loadChat = (contact) => {
            currentContact = contact;
            renderChat();
        };

        renderChat();
    </script>
</body>
</html>
