<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Connexion</title>
    <!-- Inclusion des styles via le header -->
    <?php include('header.php'); ?>
    <!-- Font Awesome CDN -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
</head>
<body class="bg-background font-sans text-h1">
    <!-- Conteneur principal -->
    <div class="relative min-h-screen flex flex-col justify-center items-center">
        <!-- SVG décoratif -->
        <div class="absolute top-0 left-0 w-full h-2/4 z-0 md:h-2/3 md:max-w-4xl md:mx-auto">
            <img
                src="data:image/svg+xml,%3Csvg width='741' height='589' viewBox='0 0 741 589' fill='none' xmlns='http://www.w3.org/2000/svg'%3E%3Cpath d='M227.5 264C25.1 279.2 -58.5 486.667 -75 588.5V-67H739.5C653.167 37 429.9 248.8 227.5 264Z' fill='%236BABE8' fill-opacity='0.6' stroke='%236BABE8'/%3E%3Cpath d='M168.5 206C-33.9 221.2 -117.5 428.667 -134 530.5V-125H680.5C594.167 -21 370.9 190.8 168.5 206Z' fill='%234D6695' fill-opacity='0.6' stroke='%234D6695'/%3E%3C/svg%3E%0A"
                alt="SVG décoratif"
                class="w-full h-full object-cover z-[-1]"
            />
        </div>

        <!-- Formulaire -->
        <form action="traite_login_prof.php" class="relative w-full max-w-md px-6 py-8 md:bg-card-background md:rounded-lg md:shadow-lg md:p-8 flex flex-col justify-center items-center z-10" method="POST">
            <h1 class="text-3xl font-bold text-center mb-8">Connexion Professeur</h1>

            <!-- Champ Email -->
            <div class="w-full mb-6">
                <label for="email" class="block text-sm font-medium mb-2">Mail universitaire</label>
                <input
                    type="email"
                    name="login"
                    placeholder="Mailuniv@email.com"
                    class="bg-card-background w-full p-3 border rounded-lg shadow-sm focus:outline-none focus:ring focus:ring-button"
                />
                <?php if (isset($_GET["err"]) && $_GET["err"] == "login") { ?>
                <div class="error-message">ATTENTION MAUVAIS LOGIN</div>
                <?php } ?>
            </div>

            <!-- Champ Mot de Passe -->
            <div class="w-full mb-6 relative">
                <label for="password" class="block text-sm font-medium mb-2">Mot de passe</label>
                <input
                    type="password"
                    name="password"
                    placeholder="••••••••"
                    class="bg-card-background w-full p-3 border rounded-lg shadow-sm focus:outline-none focus:ring focus:ring-button"
                >
                <?php if (isset($_GET["err"]) && $_GET["err"] == "password") { ?>
                <div class="error-message">ATTENTION MAUVAIS MOT DE PASSE</div>
                <?php } ?>
                <button
                    type="button"
                    id="togglePassword"
                    class="absolute top-[3.25rem] right-4 transform -translate-y-1/2 text-gray-500 focus:outline-none"
                    style="height: 100%; display: flex; align-items: center; justify-content: center;"
                >
                    <i class="fas fa-eye" id="toggleIcon"></i>
                </button>
        </form>

            <!-- Checkbox et lien mot de passe oublié -->
            <div class="w-full flex justify-between items-center mb-6">
                <label class="flex items-center text-sm">
                    <input type="checkbox" class="mr-2" />
                    Se souvenir de moi
                </label>
                <a href="#" class="text-sm text-blue-500 hover:underline">Mot de passe oublié ?</a>
            </div>

            <!-- Bouton Connexion -->
            <div class="w-full">
                <button class="w-full bg-button text-titre py-3 rounded-lg font-semibold shadow hover:bg-blue-600">
                    Connexion
                </button>
            </div>
        </div>
    </div>

    <a href="index.php">Vous êtes élève ? Alors connectez-vous ici !</a>
    <a href="login.admin.php">Vous êtes l'administrateur ? Alors connectez-vous ici !</a>
    <!-- Script pour l'affichage/mot de passe -->
    <script>
        const passwordField = document.getElementById("password");
        const togglePassword = document.getElementById("togglePassword");
        const toggleIcon = document.getElementById("toggleIcon");

        togglePassword.addEventListener("click", () => {
            const type = passwordField.type === "password" ? "text" : "password";
            passwordField.type = type;

            // Change the icon
            toggleIcon.classList.toggle("fa-eye");
            toggleIcon.classList.toggle("fa-eye-slash");
        });
    </script>
</body>
</html>