<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Espace Prof</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-50 flex">

<?php
session_start();
include "conn.php";
// Inclure la barre de navigation ici car elle est déjà incluse dans un autre fichier
include "sidebar-admin.php";

// Absences Form
echo "<div class='flex-1 p-8 ml-64'>"; 
echo "<h2 class='text-2xl font-semibold text-gray-800 mt-6 mb-4'>Absences</h2>";
echo "<form action='ajout-absence.php' method='POST' class='space-y-4'>";
$requete = "SELECT DISTINCT id_user FROM utilisateur";
$stmt = $db->query($requete);
$eleves = $stmt->fetchAll(PDO::FETCH_ASSOC);
echo "
    <div>
        <label for='eleve' class='block text-gray-600'>Élève :</label>
        <select name='eleve' id='eleve' class='w-full p-2 border border-gray-300 rounded-md' required>";
foreach ($eleves as $eleve) {
    echo "<option value='{$eleve["id_user"]}'>{$eleve["id_user"]}</option>";
}
echo "</select>
    </div>";

$requete = "SELECT DISTINCT type FROM type";
$stmt = $db->query($requete);
$types = $stmt->fetchAll(PDO::FETCH_ASSOC);
echo "
    <div>
        <label for='temps' class='block text-gray-600'>Temps :</label>
        <input type='text' name='temps' id='temps' class='w-full p-2 border border-gray-300 rounded-md' required>
    </div>";

echo "
    <div>
        <label for='type' class='block text-gray-600'>Type :</label>
        <select name='type' id='type' class='w-full p-2 border border-gray-300 rounded-md' required>";
foreach ($types as $type) {
    echo "<option value='{$type["type"]}'>{$type["type"]}</option>";
}
echo "</select>
    </div>";

$requete = "SELECT DISTINCT nom_matiere FROM matieres";
$stmt = $db->query($requete);
$matieres = $stmt->fetchAll(PDO::FETCH_ASSOC);
echo "
    <div>
        <label for='matiere' class='block text-gray-600'>Matière :</label>
        <select name='matiere' id='matiere' class='w-full p-2 border border-gray-300 rounded-md' required>";
foreach ($matieres as $matiere) {
    echo "<option value='{$matiere["nom_matiere"]}'>{$matiere["nom_matiere"]}</option>";
}
echo "</select>
    </div>";

echo "
    <div>
        <label for='date' class='block text-gray-600'>Date :</label>
        <input type='date' name='date' class='w-full p-2 border border-gray-300 rounded-md' required>
    </div>

    <div>
        <input type='submit' value='Entrer' class='w-full bg-blue-600 text-white p-2 rounded-md hover:bg-blue-700'>
    </div>
</form>";

// Affichage des absences
echo "<h2 class='text-2xl font-semibold text-gray-800 mt-6 mb-4'>Absences enregistrées</h2>";
$requete = "SELECT * FROM retards_absences";
$stmt = $db->query($requete);
$absences = $stmt->fetchAll(PDO::FETCH_ASSOC);
foreach ($absences as $absence) {
    echo "
    <div class='bg-white p-4 rounded-md shadow-sm mb-4'>
        <h3 class='text-xl font-semibold text-gray-700'>Matière : {$absence["nom_matiere"]}</h3>
        <p class='text-gray-600'>Élève : {$absence["id_user"]}</p>
        <p class='text-gray-600'>Type : {$absence["type"]}</p>
        <p class='text-gray-600'>Temps : {$absence["temps"]}</p>
        <p class='text-gray-600'>Date : {$absence["date"]}</p>
        <a href='supr_absences.php?id={$absence["id_retards_absences"]}' class='text-blue-600 hover:underline'>Supprimer l'absence</a>
    </div>";
}

// Notes Form
echo "<h2 class='text-2xl font-semibold text-gray-800 mt-6 mb-4'>Notes</h2>";
echo "<form action='ajout-note.php' method='POST' class='space-y-4'>";
$requete = "SELECT DISTINCT id_user FROM utilisateur";
$stmt = $db->query($requete);
$utilisateurs = $stmt->fetchAll(PDO::FETCH_ASSOC);
echo "
    <div>
        <label for='eleve' class='block text-gray-600'>Élève :</label>
        <select name='eleve' id='eleve' class='w-full p-2 border border-gray-300 rounded-md' required>";
foreach ($utilisateurs as $utilisateur) {
    echo "<option value='{$utilisateur["id_user"]}'>{$utilisateur["id_user"]}</option>";
}
echo "</select>
    </div>";

$requete = "SELECT DISTINCT nom_matiere FROM matieres";
$stmt = $db->query($requete);
$matieres = $stmt->fetchAll(PDO::FETCH_ASSOC);
echo "
    <div>
        <label for='matiere' class='block text-gray-600'>Matière :</label>
        <select name='matiere' id='matiere' class='w-full p-2 border border-gray-300 rounded-md' required>";
foreach ($matieres as $matiere) {
    echo "<option value='{$matiere["nom_matiere"]}'>{$matiere["nom_matiere"]}</option>";
}
echo "</select>
    </div>";

echo "
    <div>
        <label for='note' class='block text-gray-600'>Note :</label>
        <input type='text' name='note' id='note' class='w-full p-2 border border-gray-300 rounded-md' required>
    </div>";

echo "
    <div>
        <label for='coeff' class='block text-gray-600'>Coefficient :</label>
        <input type='text' name='coeff' id='coeff' class='w-full p-2 border border-gray-300 rounded-md' required>
    </div>";

echo "
    <div>
        <label for='date' class='block text-gray-600'>Date :</label>
        <input type='date' name='date' id='date' class='w-full p-2 border border-gray-300 rounded-md' required>
    </div>

    <div>
        <input type='submit' value='Entrer' class='w-full bg-blue-600 text-white p-2 rounded-md hover:bg-blue-700'>
    </div>
</form>";

// Affichage des notes
echo "<h2 class='text-2xl font-semibold text-gray-800 mt-6 mb-4'>Notes enregistrées</h2>";
$requete = "SELECT * FROM notes ORDER BY id_matiere";
$stmt = $db->query($requete);
$notes = $stmt->fetchAll(PDO::FETCH_ASSOC);
foreach ($notes as $note) {
    echo "
    <div class='bg-white p-4 rounded-md shadow-sm mb-4'>
        <h3 class='text-xl font-semibold text-gray-700'>Matière : {$note["nom_matiere"]}</h3>
        <p class='text-gray-600'>Élève : {$note["id_utilisateur"]}</p>
        <p class='text-gray-600'>Note : {$note["note"]}</p>
        <p class='text-gray-600'>Coefficient : {$note["coeff"]}</p>
        <p class='text-gray-600'>Date : {$note["date"]}</p>
        <a href='supr_notes.php?id={$note["id_note"]}' class='text-blue-600 hover:underline'>Supprimer la note</a>
    </div>";
}
// Affichage des cours
echo "<h2 class='text-2xl font-semibold text-gray-800 mt-6 mb-4'>Cours enregistrés</h2>";
$requete = "SELECT * FROM cours";
$stmt = $db->query($requete);
$cours = $stmt->fetchAll(PDO::FETCH_ASSOC);
foreach ($cours as $cours_item) {
    echo "
    <div class='bg-white p-4 rounded-md shadow-sm mb-4'>
        <h3 class='text-xl font-semibold text-gray-700'>Nom du Cours : {$cours_item["nom_cours"]}</h3>
        <p class='text-gray-600'>Matière : {$cours_item["nom_matiere"]}</p>
        <p class='text-gray-600'>Contenu : {$cours_item["contenu"]}</p>
        <p class='text-gray-600'>Date : {$cours_item["date"]}</p>
        <a href='supr_cours.php?id={$cours_item["id_cours"]}' class='text-blue-600 hover:underline'>Supprimer le cours</a>
    </div>";
}

// Professeurs
echo "<h2 class='text-2xl font-semibold text-gray-800 mt-6 mb-4'>Professeurs</h2>";
$requete = "SELECT * FROM profs";
$stmt = $db->query($requete);
$profs = $stmt->fetchAll(PDO::FETCH_ASSOC);
foreach ($profs as $prof) {
    echo "
    <div class='bg-white p-4 rounded-md shadow-sm mb-4'>
        <h3 class='text-xl font-semibold text-gray-700'>Nom : {$prof["nom"]} {$prof["prenom"]}</h3>
        <p class='text-gray-600'>Matière : {$prof["nom_matiere"]}</p>
        <p class='text-gray-600'>Email : {$prof["login"]}</p>
        <a href='supr_prof.php?id={$prof["id_prof"]}' class='text-blue-600 hover:underline'>Supprimer le professeur</a>
        <a href='modif_prof.php?id={$prof["id_prof"]}' class='text-yellow-600 hover:underline'>Modifier le professeur</a>
    </div>";
}

// Élèves
echo "<h2 class='text-2xl font-semibold text-gray-800 mt-6 mb-4'>Élèves</h2>";
$requete = "SELECT * FROM utilisateur";
$stmt = $db->query($requete);
$eleves = $stmt->fetchAll(PDO::FETCH_ASSOC);
foreach ($eleves as $eleve) {
    echo "
    <div class='bg-white p-4 rounded-md shadow-sm mb-4'>
        <h3 class='text-xl font-semibold text-gray-700'>Nom : {$eleve["nom"]} {$eleve["prenom"]}</h3>
        <p class='text-gray-600'>Email : {$eleve["login"]}</p>
        <a href='supr_eleve.php?id={$eleve["id_user"]}' class='text-blue-600 hover:underline'>Supprimer l'élève</a>
        <a href='modif_eleve.php?id={$eleve["id_user"]}' class='text-yellow-600 hover:underline'>Modifier l'élève</a>
    </div>";
}

echo "</div>";
?>
</body>
</html>
