<?php
session_start();
include 'conn.php';

// Vérification des données envoyées via POST
if (
    isset($_POST["nom_cours"], $_POST["contenu"], $_POST["date"]) &&
    !empty(trim($_POST["nom_cours"])) &&
    !empty(trim($_POST["contenu"])) &&
    !empty(trim($_POST["date"])) 
) {
    try {
        // Récupérer l'ID du professeur connecté
        $id_prof = $_SESSION['id_prof'];

        // Récupérer l'ID de la matière du professeur
        $requete_matiere = "SELECT id_matiere FROM matieres WHERE id_prof = :id_prof LIMIT 1";
        $stmt_matiere = $db->prepare($requete_matiere);
        $stmt_matiere->execute(['id_prof' => $id_prof]);
        $matiere = $stmt_matiere->fetch(PDO::FETCH_ASSOC);

        if ($matiere) {
            $id_matiere = $_SESSION['id_matiere']; // ID de la matière du professeur

            // Préparation de la requête pour insérer un cours
            $requete = "INSERT INTO cours (id_cours, nom_cours, contenu, date, id_matiere) 
                        VALUES (NULL, :nom_cours, :contenu, :date, :id_matiere)";
            $stmt = $db->prepare($requete);

            // Liaison des valeurs
            $stmt->bindValue(':nom_cours', trim($_POST["nom_cours"]), PDO::PARAM_STR);
            $stmt->bindValue(':contenu', trim($_POST["contenu"]), PDO::PARAM_STR);
            $stmt->bindValue(':date', trim($_POST["date"]), PDO::PARAM_STR);
            $stmt->bindValue(':id_matiere', $id_matiere, PDO::PARAM_INT);
            // Exécution de la requête
            $stmt->execute();

            // Redirection après succès
            header('Location: espace-prof.php');
            exit;
        } else {
            echo "Aucune matière trouvée pour ce professeur.";
        }

    } catch (PDOException $e) {
        // Gestion des erreurs
        echo "Erreur lors de l'insertion du cours : " . htmlspecialchars($e->getMessage());
    }
} else {
    // Si des données sont manquantes ou invalides
    echo "Veuillez remplir tous les champs correctement.";
}
?>
