<?php
include 'conn.php';
session_start();

// Vérification des données envoyées via POST
if (
    isset($_POST["eleve"], $_POST["temps"], $_POST["type"], $_POST["matiere"], $_POST["date"]) &&
    !empty($_POST["eleve"]) &&
    !empty($_POST["temps"]) &&
    !empty($_POST["type"]) &&
    !empty($_POST["matiere"]) &&
    !empty($_POST["date"])
) {
    try {
        // Préparation de la requête
        $requete = "INSERT INTO retards_absences (id_user, temps, type, nom_matiere, date) 
                    VALUES (:eleve, :temps, :type, :matiere, :date)";
        $stmt = $db->prepare($requete);

        // Liaison des valeurs
        $stmt->bindValue(':eleve', $_POST["eleve"], PDO::PARAM_STR);
        $stmt->bindValue(':temps', $_POST["temps"], PDO::PARAM_STR);
        $stmt->bindValue(':type', $_POST["type"], PDO::PARAM_STR);
        $stmt->bindValue(':matiere', $_POST["matiere"], PDO::PARAM_STR);
        $stmt->bindValue(':date', $_POST["date"], PDO::PARAM_STR);

        // Exécution de la requête
        $stmt->execute();

        // Redirection après succès
        header('Location: espace-administrateur.php');
        exit;
    } catch (PDOException $e) {
        // Gestion des erreurs
        echo "Erreur lors de l'insertion : " . $e->getMessage();
    }
} else {
    // Si des données sont manquantes ou invalides
    echo "Veuillez remplir tous les champs correctement.";
}
?>
