<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Accueil</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 text-gray-900 flex">

    <!-- Sidebar -->
    <?php 
    session_start();
    include('sidebar.php');
    ?>

    <!-- Overlay (for mobile) -->
    <div id="overlay" class="fixed inset-0 bg-black bg-opacity-50 z-20 hidden"></div>

    <!-- Main Content -->
    <div class="flex-1 flex flex-col relative">
        <!-- Mobile Header -->
        <header class="p-4 lg:hidden fixed top-0 left-0 w-full bg-white z-40 shadow-md flex items-center justify-between">
            <button id="menu-button" class="text-blue-500">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M4 6h16M4 12h16m-7 6h7" />
                </svg>
            </button>
            <h1 class="text-lg font-bold">Accueil</h1>
        </header>

        <!-- Header for Larger Screens -->
        <header class="hidden lg:block bg-white shadow-md w-full p-4">
            <h1 class="text-2xl font-bold text-center">Accueil</h1>
        </header>

        <!-- Page Content -->
        <main class="flex-1 p-6 md:p-12 space-y-8 mt-16 lg:mt-0">
            <section class="grid grid-cols-1 md:grid-cols-4 gap-6">
                <!-- Emploi du temps -->
                <div class="col-span-1 bg-white rounded-lg shadow p-6">
                    <h2 class="text-lg font-bold mb-4 text-blue-500">Emploi du temps</h2>
                    <div class="space-y-4">
                        <div class="bg-red-100 p-4 rounded-lg">
                            <p class="font-semibold">R3.03 JavaScript - B</p>
                            <p class="text-sm text-gray-600">Salle 126</p>
                        </div>
                        <div class="bg-orange-100 p-4 rounded-lg">
                            <p class="font-semibold">R3.03 JavaScript - B</p>
                            <p class="text-sm text-gray-600">Salle 126</p>
                        </div>
                        <div class="bg-green-100 p-4 rounded-lg">
                            <p class="font-semibold">R3.14 Anglais - B</p>
                            <p class="text-sm text-gray-600">Salle 226</p>
                        </div>
                        <div class="bg-purple-100 p-4 rounded-lg">
                            <p class="font-semibold">R3.14 Déploiement de Services - B</p>
                            <p class="text-sm text-gray-600">Salle 16</p>
                        </div>
                    </div>
                </div>

                <!-- Notes -->
                <div class="col-span-1 bg-white rounded-lg shadow p-6">
                    <h2 class="text-lg font-bold mb-4 text-blue-500">Notes</h2>
                    <div class="space-y-4">
                        <div class="flex justify-between">
                            <?php
                            $requete = "SELECT * FROM notes";
                            $stmt = $db->query($requete);
                            $notes = $stmt->fetchAll(PDO::FETCH_ASSOC);
                            foreach ($notes as $notes) {
                            echo"
                            <div class='flex justify-between'>
                                <p class='font-semibold'>{$notes["note"]}/20</p>
                                <p class='text-sm text-gray-600'>{$notes["id_matiere"]}</p>
                                <p class='text-sm text-gray-600'>{$notes["date"]}</p>
                            </div>
                            ";
                            }
                            ?>
                        </div>
                    </div>
                </div>

                <!-- Ressources -->
                <div class="col-span-1 bg-white rounded-lg shadow p-6">
                    <h2 class="text-lg font-bold mb-4 text-blue-500">Ressources</h2>
                    <ul class="list-disc pl-6 text-gray-700">
                        <?php
                            $requete = "SELECT * FROM matieres";
                            $stmt = $db->query($requete);
                            $matiere = $stmt->fetchAll(PDO::FETCH_ASSOC);
                            foreach ($matiere as $matiere) {
                            echo"
                            <li><a href='ressources-cours.php?id={$matiere['id_matiere']}'>{$matiere['nom_matiere']}</a></li>
                            ";
                            }
                            ?>
                    </ul>
                </div>

                <!-- Absences -->
                <div class="col-span-1 bg-white rounded-lg shadow p-6">
                    <h2 class="text-lg font-bold mb-4 text-blue-500">Absences</h2>
                    <p>Absence en cours : <span class="font-semibold">25 h</span></p>
                    <p>Non justifiée(s) : <span class="font-semibold">1</span></p>
                </div>
            </section>

            <section class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Menu du jour -->
                <div class="col-span-1 bg-white rounded-lg shadow p-6">
                    <h2 class="text-lg font-bold mb-4 text-blue-500">Menu du jour</h2>
                    <p><span class="font-semibold">Crous : IUT</span></p>
                    <ul class="list-disc pl-6 text-gray-700">
                        <li>Entrée : Salade de pâtes / Sardines</li>
                        <li>Plat : Poulet & pommes de terre</li>
                        <li>Dessert : Salade de fruit</li>
                    </ul>
                </div>

                <!-- Messagerie -->
                <div class="col-span-1 bg-white rounded-lg shadow p-6">
                    <h2 class="text-lg font-bold mb-4 text-blue-500">Messagerie</h2>
                    <ul class="space-y-2">
                        <li class="flex items-center">
                            <div class="w-8 h-8 bg-blue-100 rounded-full flex items-center justify-center text-blue-500">G</div>
                            <p class="ml-4">Gaëlle Charpentier</p>
                        </li>
                        <li class="flex items-center">
                            <div class="w-8 h-8 bg-red-100 rounded-full flex items-center justify-center text-red-500">C</div>
                            <p class="ml-4">Colheen Nkodia Diabaté</p>
                        </li>
                        <li class="flex items-center">
                            <div class="w-8 h-8 bg-green-100 rounded-full flex items-center justify-center text-green-500">A</div>
                            <p class="ml-4">Alexandre Leroy</p>
                        </li>
                    </ul>
                </div>
            </section>
        </main>
    </div>

    <!-- JavaScript -->
    <script>
        // Sidebar gestion
        const menuButton = document.getElementById('menu-button');
        const sidebar = document.getElementById('sidebar');
        const overlay = document.getElementById('overlay');

        menuButton.addEventListener('click', () => {
            sidebar.classList.toggle('-translate-x-full');
            overlay.classList.toggle('hidden');
        });

        overlay.addEventListener('click', () => {
            sidebar.classList.add('-translate-x-full');
            overlay.classList.add('hidden');
        });
    </script>
</body>
</html>
